// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Monitor.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Monitor
{
    public partial class PipelineGroupData : IUtf8JsonSerializable, IJsonModel<PipelineGroupData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PipelineGroupData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PipelineGroupData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineGroupData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PipelineGroupData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(ExtendedLocation))
            {
                writer.WritePropertyName("extendedLocation"u8);
                JsonSerializer.Serialize(writer, ExtendedLocation);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Replicas))
            {
                writer.WritePropertyName("replicas"u8);
                writer.WriteNumberValue(Replicas.Value);
            }
            if (Optional.IsCollectionDefined(Receivers))
            {
                writer.WritePropertyName("receivers"u8);
                writer.WriteStartArray();
                foreach (var item in Receivers)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Processors))
            {
                writer.WritePropertyName("processors"u8);
                writer.WriteStartArray();
                foreach (var item in Processors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Exporters))
            {
                writer.WritePropertyName("exporters"u8);
                writer.WriteStartArray();
                foreach (var item in Exporters)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Service))
            {
                writer.WritePropertyName("service"u8);
                writer.WriteObjectValue(Service, options);
            }
            if (Optional.IsCollectionDefined(NetworkingConfigurations))
            {
                writer.WritePropertyName("networkingConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in NetworkingConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WriteEndObject();
        }

        PipelineGroupData IJsonModel<PipelineGroupData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineGroupData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PipelineGroupData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePipelineGroupData(document.RootElement, options);
        }

        internal static PipelineGroupData DeserializePipelineGroupData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ExtendedLocation extendedLocation = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            int? replicas = default;
            IList<PipelineGroupReceiver> receivers = default;
            IList<PipelineGroupProcessor> processors = default;
            IList<PipelineGroupExporter> exporters = default;
            PipelineGroupService service = default;
            IList<PipelineGroupNetworkingConfiguration> networkingConfigurations = default;
            MonitorProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("extendedLocation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    extendedLocation = JsonSerializer.Deserialize<ExtendedLocation>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("replicas"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            replicas = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("receivers"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PipelineGroupReceiver> array = new List<PipelineGroupReceiver>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PipelineGroupReceiver.DeserializePipelineGroupReceiver(item, options));
                            }
                            receivers = array;
                            continue;
                        }
                        if (property0.NameEquals("processors"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PipelineGroupProcessor> array = new List<PipelineGroupProcessor>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PipelineGroupProcessor.DeserializePipelineGroupProcessor(item, options));
                            }
                            processors = array;
                            continue;
                        }
                        if (property0.NameEquals("exporters"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PipelineGroupExporter> array = new List<PipelineGroupExporter>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PipelineGroupExporter.DeserializePipelineGroupExporter(item, options));
                            }
                            exporters = array;
                            continue;
                        }
                        if (property0.NameEquals("service"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            service = PipelineGroupService.DeserializePipelineGroupService(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("networkingConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PipelineGroupNetworkingConfiguration> array = new List<PipelineGroupNetworkingConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PipelineGroupNetworkingConfiguration.DeserializePipelineGroupNetworkingConfiguration(item, options));
                            }
                            networkingConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new MonitorProvisioningState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PipelineGroupData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                extendedLocation,
                replicas,
                receivers ?? new ChangeTrackingList<PipelineGroupReceiver>(),
                processors ?? new ChangeTrackingList<PipelineGroupProcessor>(),
                exporters ?? new ChangeTrackingList<PipelineGroupExporter>(),
                service,
                networkingConfigurations ?? new ChangeTrackingList<PipelineGroupNetworkingConfiguration>(),
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PipelineGroupData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineGroupData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PipelineGroupData)} does not support writing '{options.Format}' format.");
            }
        }

        PipelineGroupData IPersistableModel<PipelineGroupData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineGroupData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePipelineGroupData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PipelineGroupData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PipelineGroupData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
