// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Monitor
{
    /// <summary>
    /// A class representing a collection of <see cref="PipelineGroupResource"/> and their operations.
    /// Each <see cref="PipelineGroupResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="PipelineGroupCollection"/> instance call the GetPipelineGroups method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class PipelineGroupCollection : ArmCollection, IEnumerable<PipelineGroupResource>, IAsyncEnumerable<PipelineGroupResource>
    {
        private readonly ClientDiagnostics _pipelineGroupClientDiagnostics;
        private readonly PipelineGroupsRestOperations _pipelineGroupRestClient;

        /// <summary> Initializes a new instance of the <see cref="PipelineGroupCollection"/> class for mocking. </summary>
        protected PipelineGroupCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="PipelineGroupCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal PipelineGroupCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _pipelineGroupClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Monitor", PipelineGroupResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(PipelineGroupResource.ResourceType, out string pipelineGroupApiVersion);
            _pipelineGroupRestClient = new PipelineGroupsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, pipelineGroupApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create or update a pipeline group instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups/{pipelineGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="pipelineGroupName"> The name of pipeline group. The name is case insensitive. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="pipelineGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="pipelineGroupName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<PipelineGroupResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string pipelineGroupName, PipelineGroupData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(pipelineGroupName, nameof(pipelineGroupName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _pipelineGroupClientDiagnostics.CreateScope("PipelineGroupCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _pipelineGroupRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, data, cancellationToken).ConfigureAwait(false);
                var operation = new MonitorArmOperation<PipelineGroupResource>(new PipelineGroupOperationSource(Client), _pipelineGroupClientDiagnostics, Pipeline, _pipelineGroupRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update a pipeline group instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups/{pipelineGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="pipelineGroupName"> The name of pipeline group. The name is case insensitive. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="pipelineGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="pipelineGroupName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<PipelineGroupResource> CreateOrUpdate(WaitUntil waitUntil, string pipelineGroupName, PipelineGroupData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(pipelineGroupName, nameof(pipelineGroupName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _pipelineGroupClientDiagnostics.CreateScope("PipelineGroupCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _pipelineGroupRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, data, cancellationToken);
                var operation = new MonitorArmOperation<PipelineGroupResource>(new PipelineGroupOperationSource(Client), _pipelineGroupClientDiagnostics, Pipeline, _pipelineGroupRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns the specific pipeline group instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups/{pipelineGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="pipelineGroupName"> The name of pipeline group. The name is case insensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="pipelineGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="pipelineGroupName"/> is null. </exception>
        public virtual async Task<Response<PipelineGroupResource>> GetAsync(string pipelineGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(pipelineGroupName, nameof(pipelineGroupName));

            using var scope = _pipelineGroupClientDiagnostics.CreateScope("PipelineGroupCollection.Get");
            scope.Start();
            try
            {
                var response = await _pipelineGroupRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new PipelineGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns the specific pipeline group instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups/{pipelineGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="pipelineGroupName"> The name of pipeline group. The name is case insensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="pipelineGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="pipelineGroupName"/> is null. </exception>
        public virtual Response<PipelineGroupResource> Get(string pipelineGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(pipelineGroupName, nameof(pipelineGroupName));

            using var scope = _pipelineGroupClientDiagnostics.CreateScope("PipelineGroupCollection.Get");
            scope.Start();
            try
            {
                var response = _pipelineGroupRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new PipelineGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all workspaces in the specified resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="PipelineGroupResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<PipelineGroupResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _pipelineGroupRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _pipelineGroupRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new PipelineGroupResource(Client, PipelineGroupData.DeserializePipelineGroupData(e)), _pipelineGroupClientDiagnostics, Pipeline, "PipelineGroupCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all workspaces in the specified resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="PipelineGroupResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<PipelineGroupResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _pipelineGroupRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _pipelineGroupRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new PipelineGroupResource(Client, PipelineGroupData.DeserializePipelineGroupData(e)), _pipelineGroupClientDiagnostics, Pipeline, "PipelineGroupCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups/{pipelineGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="pipelineGroupName"> The name of pipeline group. The name is case insensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="pipelineGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="pipelineGroupName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string pipelineGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(pipelineGroupName, nameof(pipelineGroupName));

            using var scope = _pipelineGroupClientDiagnostics.CreateScope("PipelineGroupCollection.Exists");
            scope.Start();
            try
            {
                var response = await _pipelineGroupRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups/{pipelineGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="pipelineGroupName"> The name of pipeline group. The name is case insensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="pipelineGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="pipelineGroupName"/> is null. </exception>
        public virtual Response<bool> Exists(string pipelineGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(pipelineGroupName, nameof(pipelineGroupName));

            using var scope = _pipelineGroupClientDiagnostics.CreateScope("PipelineGroupCollection.Exists");
            scope.Start();
            try
            {
                var response = _pipelineGroupRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups/{pipelineGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="pipelineGroupName"> The name of pipeline group. The name is case insensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="pipelineGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="pipelineGroupName"/> is null. </exception>
        public virtual async Task<NullableResponse<PipelineGroupResource>> GetIfExistsAsync(string pipelineGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(pipelineGroupName, nameof(pipelineGroupName));

            using var scope = _pipelineGroupClientDiagnostics.CreateScope("PipelineGroupCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _pipelineGroupRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<PipelineGroupResource>(response.GetRawResponse());
                return Response.FromValue(new PipelineGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/pipelineGroups/{pipelineGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PipelineGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PipelineGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="pipelineGroupName"> The name of pipeline group. The name is case insensitive. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="pipelineGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="pipelineGroupName"/> is null. </exception>
        public virtual NullableResponse<PipelineGroupResource> GetIfExists(string pipelineGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(pipelineGroupName, nameof(pipelineGroupName));

            using var scope = _pipelineGroupClientDiagnostics.CreateScope("PipelineGroupCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _pipelineGroupRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, pipelineGroupName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<PipelineGroupResource>(response.GetRawResponse());
                return Response.FromValue(new PipelineGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<PipelineGroupResource> IEnumerable<PipelineGroupResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<PipelineGroupResource> IAsyncEnumerable<PipelineGroupResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
