// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Monitor.Models;

namespace Azure.ResourceManager.Monitor
{
    /// <summary>
    /// A class representing the MonitorWorkspaceResource data model.
    /// An Azure Monitor Workspace definition.
    /// </summary>
    public partial class MonitorWorkspaceResourceData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceResourceData"/>. </summary>
        /// <param name="location"> The location. </param>
        public MonitorWorkspaceResourceData(AzureLocation location) : base(location)
        {
            PrivateEndpointConnections = new ChangeTrackingList<MonitorWorkspacePrivateEndpointConnection>();
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> Resource entity tag (ETag). </param>
        /// <param name="defaultIngestionSettings"> The Data Collection Rule and Endpoint used for ingestion by default. </param>
        /// <param name="metrics"> Properties related to the metrics container in the Azure Monitor Workspace. </param>
        /// <param name="accountId"> The immutable ID of the Azure Monitor workspace. This property is read-only. </param>
        /// <param name="metricsPropertiesMetrics"> Information about metrics for the Azure Monitor workspace. </param>
        /// <param name="provisioningState"> The provisioning state of the Azure Monitor workspace. Set to Succeeded if everything is healthy. </param>
        /// <param name="defaultIngestionSettingsPropertiesDefaultIngestionSettings"> The Data Collection Rule and Endpoint used for ingestion by default. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="publicNetworkAccess"> Gets or sets allow or disallow public network access to workspace. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorWorkspaceResourceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ETag? etag, MonitorWorkspaceDefaultIngestionSettings defaultIngestionSettings, MonitorWorkspaceMetrics metrics, string accountId, MonitorWorkspaceMetricProperties metricsPropertiesMetrics, MonitorProvisioningState? provisioningState, MonitorWorkspaceIngestionSettings defaultIngestionSettingsPropertiesDefaultIngestionSettings, IReadOnlyList<MonitorWorkspacePrivateEndpointConnection> privateEndpointConnections, MonitorWorkspacePublicNetworkAccess? publicNetworkAccess, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ETag = etag;
            DefaultIngestionSettings = defaultIngestionSettings;
            Metrics = metrics;
            AccountId = accountId;
            MetricsPropertiesMetrics = metricsPropertiesMetrics;
            ProvisioningState = provisioningState;
            DefaultIngestionSettingsPropertiesDefaultIngestionSettings = defaultIngestionSettingsPropertiesDefaultIngestionSettings;
            PrivateEndpointConnections = privateEndpointConnections;
            PublicNetworkAccess = publicNetworkAccess;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceResourceData"/> for deserialization. </summary>
        internal MonitorWorkspaceResourceData()
        {
        }

        /// <summary> Resource entity tag (ETag). </summary>
        public ETag? ETag { get; }
        /// <summary> The Data Collection Rule and Endpoint used for ingestion by default. </summary>
        public MonitorWorkspaceDefaultIngestionSettings DefaultIngestionSettings { get; }
        /// <summary> Properties related to the metrics container in the Azure Monitor Workspace. </summary>
        public MonitorWorkspaceMetrics Metrics { get; }
        /// <summary> The immutable ID of the Azure Monitor workspace. This property is read-only. </summary>
        public string AccountId { get; }
        /// <summary> Information about metrics for the Azure Monitor workspace. </summary>
        public MonitorWorkspaceMetricProperties MetricsPropertiesMetrics { get; set; }
        /// <summary> The provisioning state of the Azure Monitor workspace. Set to Succeeded if everything is healthy. </summary>
        public MonitorProvisioningState? ProvisioningState { get; }
        /// <summary> The Data Collection Rule and Endpoint used for ingestion by default. </summary>
        public MonitorWorkspaceIngestionSettings DefaultIngestionSettingsPropertiesDefaultIngestionSettings { get; }
        /// <summary> List of private endpoint connections. </summary>
        public IReadOnlyList<MonitorWorkspacePrivateEndpointConnection> PrivateEndpointConnections { get; }
        /// <summary> Gets or sets allow or disallow public network access to workspace. </summary>
        public MonitorWorkspacePublicNetworkAccess? PublicNetworkAccess { get; }
    }
}
