// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The WindowsEventLogDataSourceStream. </summary>
    public readonly partial struct WindowsEventLogDataSourceStream : IEquatable<WindowsEventLogDataSourceStream>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WindowsEventLogDataSourceStream"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WindowsEventLogDataSourceStream(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftWindowsEventValue = "Microsoft-WindowsEvent";
        private const string MicrosoftEventValue = "Microsoft-Event";

        /// <summary> Microsoft-WindowsEvent. </summary>
        public static WindowsEventLogDataSourceStream MicrosoftWindowsEvent { get; } = new WindowsEventLogDataSourceStream(MicrosoftWindowsEventValue);
        /// <summary> Microsoft-Event. </summary>
        public static WindowsEventLogDataSourceStream MicrosoftEvent { get; } = new WindowsEventLogDataSourceStream(MicrosoftEventValue);
        /// <summary> Determines if two <see cref="WindowsEventLogDataSourceStream"/> values are the same. </summary>
        public static bool operator ==(WindowsEventLogDataSourceStream left, WindowsEventLogDataSourceStream right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WindowsEventLogDataSourceStream"/> values are not the same. </summary>
        public static bool operator !=(WindowsEventLogDataSourceStream left, WindowsEventLogDataSourceStream right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WindowsEventLogDataSourceStream"/>. </summary>
        public static implicit operator WindowsEventLogDataSourceStream(string value) => new WindowsEventLogDataSourceStream(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WindowsEventLogDataSourceStream other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WindowsEventLogDataSourceStream other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
