// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Monitor.Models
{
    internal static partial class ThresholdRuleConditionTimeAggregationTypeExtensions
    {
        public static string ToSerialString(this ThresholdRuleConditionTimeAggregationType value) => value switch
        {
            ThresholdRuleConditionTimeAggregationType.Average => "Average",
            ThresholdRuleConditionTimeAggregationType.Minimum => "Minimum",
            ThresholdRuleConditionTimeAggregationType.Maximum => "Maximum",
            ThresholdRuleConditionTimeAggregationType.Total => "Total",
            ThresholdRuleConditionTimeAggregationType.Last => "Last",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ThresholdRuleConditionTimeAggregationType value.")
        };

        public static ThresholdRuleConditionTimeAggregationType ToThresholdRuleConditionTimeAggregationType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Average")) return ThresholdRuleConditionTimeAggregationType.Average;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Minimum")) return ThresholdRuleConditionTimeAggregationType.Minimum;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Maximum")) return ThresholdRuleConditionTimeAggregationType.Maximum;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Total")) return ThresholdRuleConditionTimeAggregationType.Total;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Last")) return ThresholdRuleConditionTimeAggregationType.Last;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ThresholdRuleConditionTimeAggregationType value.");
        }
    }
}
