// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Base receiver using TCP as transport protocol. </summary>
    public partial class SyslogReceiver
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SyslogReceiver"/>. </summary>
        /// <param name="endpoint"> Syslog receiver endpoint definition. Example: 0.0.0.0:&lt;port&gt;. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> is null. </exception>
        public SyslogReceiver(string endpoint)
        {
            Argument.AssertNotNull(endpoint, nameof(endpoint));

            Endpoint = endpoint;
        }

        /// <summary> Initializes a new instance of <see cref="SyslogReceiver"/>. </summary>
        /// <param name="endpoint"> Syslog receiver endpoint definition. Example: 0.0.0.0:&lt;port&gt;. </param>
        /// <param name="protocol"> Protocol to parse syslog messages. Default rfc3164. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SyslogReceiver(string endpoint, SyslogProtocol? protocol, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Endpoint = endpoint;
            Protocol = protocol;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SyslogReceiver"/> for deserialization. </summary>
        internal SyslogReceiver()
        {
        }

        /// <summary> Syslog receiver endpoint definition. Example: 0.0.0.0:&lt;port&gt;. </summary>
        public string Endpoint { get; set; }
        /// <summary> Protocol to parse syslog messages. Default rfc3164. </summary>
        public SyslogProtocol? Protocol { get; set; }
    }
}
