// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Protocol to parse syslog messages. Default rfc3164. </summary>
    public readonly partial struct SyslogProtocol : IEquatable<SyslogProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SyslogProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SyslogProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Rfc3164Value = "rfc3164";
        private const string Rfc5424Value = "rfc5424";

        /// <summary> rfc3164 protocol. </summary>
        public static SyslogProtocol Rfc3164 { get; } = new SyslogProtocol(Rfc3164Value);
        /// <summary> rfc5424 protocol. </summary>
        public static SyslogProtocol Rfc5424 { get; } = new SyslogProtocol(Rfc5424Value);
        /// <summary> Determines if two <see cref="SyslogProtocol"/> values are the same. </summary>
        public static bool operator ==(SyslogProtocol left, SyslogProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SyslogProtocol"/> values are not the same. </summary>
        public static bool operator !=(SyslogProtocol left, SyslogProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SyslogProtocol"/>. </summary>
        public static implicit operator SyslogProtocol(string value) => new SyslogProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SyslogProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SyslogProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
