// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The SyslogDataSourceStream. </summary>
    public readonly partial struct SyslogDataSourceStream : IEquatable<SyslogDataSourceStream>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SyslogDataSourceStream"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SyslogDataSourceStream(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftSyslogValue = "Microsoft-Syslog";

        /// <summary> Microsoft-Syslog. </summary>
        public static SyslogDataSourceStream MicrosoftSyslog { get; } = new SyslogDataSourceStream(MicrosoftSyslogValue);
        /// <summary> Determines if two <see cref="SyslogDataSourceStream"/> values are the same. </summary>
        public static bool operator ==(SyslogDataSourceStream left, SyslogDataSourceStream right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SyslogDataSourceStream"/> values are not the same. </summary>
        public static bool operator !=(SyslogDataSourceStream left, SyslogDataSourceStream right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SyslogDataSourceStream"/>. </summary>
        public static implicit operator SyslogDataSourceStream(string value) => new SyslogDataSourceStream(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SyslogDataSourceStream other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SyslogDataSourceStream other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
