// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The encoding of the stream being received. </summary>
    public readonly partial struct StreamEncodingType : IEquatable<StreamEncodingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamEncodingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamEncodingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NopValue = "nop";
        private const string Utf8Value = "utf-8";
        private const string Utf16LeValue = "utf-16le";
        private const string Utf16BeValue = "utf-16be";
        private const string AsciiValue = "ascii";
        private const string Big5Value = "big5";

        /// <summary> No encoding validation. Treats the file as a stream of raw bytes. </summary>
        public static StreamEncodingType Nop { get; } = new StreamEncodingType(NopValue);
        /// <summary> UTF-8 encoding. </summary>
        public static StreamEncodingType Utf8 { get; } = new StreamEncodingType(Utf8Value);
        /// <summary> UTF-16 encoding with little-endian byte order. </summary>
        public static StreamEncodingType Utf16Le { get; } = new StreamEncodingType(Utf16LeValue);
        /// <summary> UTF-16 encoding with little-endian byte order. </summary>
        public static StreamEncodingType Utf16Be { get; } = new StreamEncodingType(Utf16BeValue);
        /// <summary> ASCII encoding. </summary>
        public static StreamEncodingType Ascii { get; } = new StreamEncodingType(AsciiValue);
        /// <summary> The Big5 Chinese character encoding. </summary>
        public static StreamEncodingType Big5 { get; } = new StreamEncodingType(Big5Value);
        /// <summary> Determines if two <see cref="StreamEncodingType"/> values are the same. </summary>
        public static bool operator ==(StreamEncodingType left, StreamEncodingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamEncodingType"/> values are not the same. </summary>
        public static bool operator !=(StreamEncodingType left, StreamEncodingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamEncodingType"/>. </summary>
        public static implicit operator StreamEncodingType(string value) => new StreamEncodingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamEncodingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamEncodingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
