// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The rule criteria that defines the conditions of the scheduled query rule. </summary>
    internal partial class ScheduledQueryRuleCriteria
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScheduledQueryRuleCriteria"/>. </summary>
        public ScheduledQueryRuleCriteria()
        {
            AllOf = new ChangeTrackingList<ScheduledQueryRuleCondition>();
        }

        /// <summary> Initializes a new instance of <see cref="ScheduledQueryRuleCriteria"/>. </summary>
        /// <param name="allOf"> A list of conditions to evaluate against the specified scopes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScheduledQueryRuleCriteria(IList<ScheduledQueryRuleCondition> allOf, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AllOf = allOf;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A list of conditions to evaluate against the specified scopes. </summary>
        public IList<ScheduledQueryRuleCondition> AllOf { get; }
    }
}
