// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values. </summary>
    public readonly partial struct ScaleRuleMetricDimensionOperationType : IEquatable<ScaleRuleMetricDimensionOperationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScaleRuleMetricDimensionOperationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScaleRuleMetricDimensionOperationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualsValueValue = "Equals";
        private const string NotEqualsValue = "NotEquals";

        /// <summary> Equals. </summary>
        public static ScaleRuleMetricDimensionOperationType EqualsValue { get; } = new ScaleRuleMetricDimensionOperationType(EqualsValueValue);
        /// <summary> NotEquals. </summary>
        public static ScaleRuleMetricDimensionOperationType NotEquals { get; } = new ScaleRuleMetricDimensionOperationType(NotEqualsValue);
        /// <summary> Determines if two <see cref="ScaleRuleMetricDimensionOperationType"/> values are the same. </summary>
        public static bool operator ==(ScaleRuleMetricDimensionOperationType left, ScaleRuleMetricDimensionOperationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScaleRuleMetricDimensionOperationType"/> values are not the same. </summary>
        public static bool operator !=(ScaleRuleMetricDimensionOperationType left, ScaleRuleMetricDimensionOperationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScaleRuleMetricDimensionOperationType"/>. </summary>
        public static implicit operator ScaleRuleMetricDimensionOperationType(string value) => new ScaleRuleMetricDimensionOperationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScaleRuleMetricDimensionOperationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScaleRuleMetricDimensionOperationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
