// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case. </summary>
    public partial class RuleEmailAction : AlertRuleAction
    {
        /// <summary> Initializes a new instance of <see cref="RuleEmailAction"/>. </summary>
        public RuleEmailAction()
        {
            CustomEmails = new ChangeTrackingList<string>();
            OdataType = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction";
        }

        /// <summary> Initializes a new instance of <see cref="RuleEmailAction"/>. </summary>
        /// <param name="odataType"> specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="sendToServiceOwners"> Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated. </param>
        /// <param name="customEmails"> the list of administrator's custom email addresses to notify of the activation of the alert. </param>
        internal RuleEmailAction(string odataType, IDictionary<string, BinaryData> serializedAdditionalRawData, bool? sendToServiceOwners, IList<string> customEmails) : base(odataType, serializedAdditionalRawData)
        {
            SendToServiceOwners = sendToServiceOwners;
            CustomEmails = customEmails;
            OdataType = odataType ?? "Microsoft.Azure.Management.Insights.Models.RuleEmailAction";
        }

        /// <summary> Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated. </summary>
        public bool? SendToServiceOwners { get; set; }
        /// <summary> the list of administrator's custom email addresses to notify of the activation of the alert. </summary>
        public IList<string> CustomEmails { get; }
    }
}
