// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Specifies the retention policy for the log. </summary>
    public partial class RetentionPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RetentionPolicy"/>. </summary>
        /// <param name="isEnabled"> a value indicating whether the retention policy is enabled. </param>
        /// <param name="days"> the number of days for the retention in days. A value of 0 will retain the events indefinitely. </param>
        public RetentionPolicy(bool isEnabled, int days)
        {
            IsEnabled = isEnabled;
            Days = days;
        }

        /// <summary> Initializes a new instance of <see cref="RetentionPolicy"/>. </summary>
        /// <param name="isEnabled"> a value indicating whether the retention policy is enabled. </param>
        /// <param name="days"> the number of days for the retention in days. A value of 0 will retain the events indefinitely. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RetentionPolicy(bool isEnabled, int days, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            Days = days;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RetentionPolicy"/> for deserialization. </summary>
        internal RetentionPolicy()
        {
        }

        /// <summary> a value indicating whether the retention policy is enabled. </summary>
        public bool IsEnabled { get; set; }
        /// <summary> the number of days for the retention in days. A value of 0 will retain the events indefinitely. </summary>
        public int Days { get; set; }
    }
}
