// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The pipeline type. </summary>
    public readonly partial struct PipelineGroupServicePipelineType : IEquatable<PipelineGroupServicePipelineType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupServicePipelineType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PipelineGroupServicePipelineType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LogsValue = "logs";

        /// <summary> Pipeline for logs telemetry. </summary>
        public static PipelineGroupServicePipelineType Logs { get; } = new PipelineGroupServicePipelineType(LogsValue);
        /// <summary> Determines if two <see cref="PipelineGroupServicePipelineType"/> values are the same. </summary>
        public static bool operator ==(PipelineGroupServicePipelineType left, PipelineGroupServicePipelineType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PipelineGroupServicePipelineType"/> values are not the same. </summary>
        public static bool operator !=(PipelineGroupServicePipelineType left, PipelineGroupServicePipelineType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PipelineGroupServicePipelineType"/>. </summary>
        public static implicit operator PipelineGroupServicePipelineType(string value) => new PipelineGroupServicePipelineType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PipelineGroupServicePipelineType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PipelineGroupServicePipelineType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
