// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Service Info. </summary>
    public partial class PipelineGroupService
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupService"/>. </summary>
        /// <param name="pipelines"> Pipelines belonging to a given pipeline group. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipelines"/> is null. </exception>
        public PipelineGroupService(IEnumerable<PipelineGroupServicePipeline> pipelines)
        {
            Argument.AssertNotNull(pipelines, nameof(pipelines));

            Pipelines = pipelines.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupService"/>. </summary>
        /// <param name="pipelines"> Pipelines belonging to a given pipeline group. </param>
        /// <param name="persistence"> Persistence options to all pipelines in the instance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PipelineGroupService(IList<PipelineGroupServicePipeline> pipelines, PipelineGroupServicePersistenceConfigurations persistence, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Pipelines = pipelines;
            Persistence = persistence;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupService"/> for deserialization. </summary>
        internal PipelineGroupService()
        {
        }

        /// <summary> Pipelines belonging to a given pipeline group. </summary>
        public IList<PipelineGroupServicePipeline> Pipelines { get; }
        /// <summary> Persistence options to all pipelines in the instance. </summary>
        internal PipelineGroupServicePersistenceConfigurations Persistence { get; set; }
        /// <summary> The name of the mounted persistent volume. </summary>
        public string PersistencePersistentVolumeName
        {
            get => Persistence is null ? default : Persistence.PersistentVolumeName;
            set => Persistence = new PipelineGroupServicePersistenceConfigurations(value);
        }
    }
}
