// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Receiver Info. </summary>
    public partial class PipelineGroupReceiver
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupReceiver"/>. </summary>
        /// <param name="receiverType"> The type of receiver. </param>
        /// <param name="name"> The name of receiver. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public PipelineGroupReceiver(PipelineGroupReceiverType receiverType, string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            ReceiverType = receiverType;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupReceiver"/>. </summary>
        /// <param name="receiverType"> The type of receiver. </param>
        /// <param name="name"> The name of receiver. </param>
        /// <param name="syslog"> Syslog configurations. This field is mandatory for syslog type receivers. </param>
        /// <param name="otlp"> OTLP receiver configurations. This field is mandatory for OTLP and pipelineGroup receivers. </param>
        /// <param name="udp"> UDP receiver configurations. This field is mandatory for UDP receivers. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PipelineGroupReceiver(PipelineGroupReceiverType receiverType, string name, SyslogReceiver syslog, OtlpReceiver otlp, UdpReceiver udp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ReceiverType = receiverType;
            Name = name;
            Syslog = syslog;
            Otlp = otlp;
            Udp = udp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupReceiver"/> for deserialization. </summary>
        internal PipelineGroupReceiver()
        {
        }

        /// <summary> The type of receiver. </summary>
        public PipelineGroupReceiverType ReceiverType { get; set; }
        /// <summary> The name of receiver. </summary>
        public string Name { get; set; }
        /// <summary> Syslog configurations. This field is mandatory for syslog type receivers. </summary>
        public SyslogReceiver Syslog { get; set; }
        /// <summary> OTLP receiver configurations. This field is mandatory for OTLP and pipelineGroup receivers. </summary>
        internal OtlpReceiver Otlp { get; set; }
        /// <summary> OTLP GRPC endpoint definition. Example: 0.0.0.0:&lt;port&gt;. </summary>
        public string OtlpEndpoint
        {
            get => Otlp is null ? default : Otlp.Endpoint;
            set => Otlp = new OtlpReceiver(value);
        }

        /// <summary> UDP receiver configurations. This field is mandatory for UDP receivers. </summary>
        public UdpReceiver Udp { get; set; }
    }
}
