// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The processor type. </summary>
    public readonly partial struct PipelineGroupProcessorType : IEquatable<PipelineGroupProcessorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupProcessorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PipelineGroupProcessorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BatchValue = "Batch";

        /// <summary> Batch processor. </summary>
        public static PipelineGroupProcessorType Batch { get; } = new PipelineGroupProcessorType(BatchValue);
        /// <summary> Determines if two <see cref="PipelineGroupProcessorType"/> values are the same. </summary>
        public static bool operator ==(PipelineGroupProcessorType left, PipelineGroupProcessorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PipelineGroupProcessorType"/> values are not the same. </summary>
        public static bool operator !=(PipelineGroupProcessorType left, PipelineGroupProcessorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PipelineGroupProcessorType"/>. </summary>
        public static implicit operator PipelineGroupProcessorType(string value) => new PipelineGroupProcessorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PipelineGroupProcessorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PipelineGroupProcessorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
