// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Processor Info. </summary>
    public partial class PipelineGroupProcessor
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupProcessor"/>. </summary>
        /// <param name="processorType"> The type of processor. </param>
        /// <param name="name"> The name of processor. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public PipelineGroupProcessor(PipelineGroupProcessorType processorType, string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            ProcessorType = processorType;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupProcessor"/>. </summary>
        /// <param name="processorType"> The type of processor. </param>
        /// <param name="name"> The name of processor. </param>
        /// <param name="batch"> Batch processor configurations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PipelineGroupProcessor(PipelineGroupProcessorType processorType, string name, BatchProcessor batch, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProcessorType = processorType;
            Name = name;
            Batch = batch;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupProcessor"/> for deserialization. </summary>
        internal PipelineGroupProcessor()
        {
        }

        /// <summary> The type of processor. </summary>
        public PipelineGroupProcessorType ProcessorType { get; set; }
        /// <summary> The name of processor. </summary>
        public string Name { get; set; }
        /// <summary> Batch processor configurations. </summary>
        public BatchProcessor Batch { get; set; }
    }
}
