// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The type used for update operations of the PipelineGroup. </summary>
    public partial class PipelineGroupPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupPatch"/>. </summary>
        public PipelineGroupPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            Receivers = new ChangeTrackingList<PipelineGroupReceiver>();
            Processors = new ChangeTrackingList<PipelineGroupProcessor>();
            Exporters = new ChangeTrackingList<PipelineGroupExporter>();
            NetworkingConfigurations = new ChangeTrackingList<PipelineGroupNetworkingConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="replicas"> Defines the amount of replicas of the pipeline group instance. </param>
        /// <param name="receivers"> The receivers specified for a pipeline group instance. </param>
        /// <param name="processors"> The processors specified for a pipeline group instance. </param>
        /// <param name="exporters"> The exporters specified for a pipeline group instance. </param>
        /// <param name="service"> The service section for a given pipeline group instance. </param>
        /// <param name="networkingConfigurations"> Networking configurations for the pipeline group instance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PipelineGroupPatch(IDictionary<string, string> tags, int? replicas, IList<PipelineGroupReceiver> receivers, IList<PipelineGroupProcessor> processors, IList<PipelineGroupExporter> exporters, PipelineGroupService service, IList<PipelineGroupNetworkingConfiguration> networkingConfigurations, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            Replicas = replicas;
            Receivers = receivers;
            Processors = processors;
            Exporters = exporters;
            Service = service;
            NetworkingConfigurations = networkingConfigurations;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource tags. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> Defines the amount of replicas of the pipeline group instance. </summary>
        public int? Replicas { get; set; }
        /// <summary> The receivers specified for a pipeline group instance. </summary>
        public IList<PipelineGroupReceiver> Receivers { get; }
        /// <summary> The processors specified for a pipeline group instance. </summary>
        public IList<PipelineGroupProcessor> Processors { get; }
        /// <summary> The exporters specified for a pipeline group instance. </summary>
        public IList<PipelineGroupExporter> Exporters { get; }
        /// <summary> The service section for a given pipeline group instance. </summary>
        public PipelineGroupService Service { get; set; }
        /// <summary> Networking configurations for the pipeline group instance. </summary>
        public IList<PipelineGroupNetworkingConfiguration> NetworkingConfigurations { get; }
    }
}
