// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Monitor.Models
{
    public partial class PipelineGroupPatch : IUtf8JsonSerializable, IJsonModel<PipelineGroupPatch>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PipelineGroupPatch>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PipelineGroupPatch>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineGroupPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PipelineGroupPatch)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Replicas))
            {
                writer.WritePropertyName("replicas"u8);
                writer.WriteNumberValue(Replicas.Value);
            }
            if (Optional.IsCollectionDefined(Receivers))
            {
                writer.WritePropertyName("receivers"u8);
                writer.WriteStartArray();
                foreach (var item in Receivers)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Processors))
            {
                writer.WritePropertyName("processors"u8);
                writer.WriteStartArray();
                foreach (var item in Processors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Exporters))
            {
                writer.WritePropertyName("exporters"u8);
                writer.WriteStartArray();
                foreach (var item in Exporters)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Service))
            {
                writer.WritePropertyName("service"u8);
                writer.WriteObjectValue(Service, options);
            }
            if (Optional.IsCollectionDefined(NetworkingConfigurations))
            {
                writer.WritePropertyName("networkingConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in NetworkingConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PipelineGroupPatch IJsonModel<PipelineGroupPatch>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineGroupPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PipelineGroupPatch)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePipelineGroupPatch(document.RootElement, options);
        }

        internal static PipelineGroupPatch DeserializePipelineGroupPatch(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            int? replicas = default;
            IList<PipelineGroupReceiver> receivers = default;
            IList<PipelineGroupProcessor> processors = default;
            IList<PipelineGroupExporter> exporters = default;
            PipelineGroupService service = default;
            IList<PipelineGroupNetworkingConfiguration> networkingConfigurations = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("replicas"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            replicas = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("receivers"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PipelineGroupReceiver> array = new List<PipelineGroupReceiver>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PipelineGroupReceiver.DeserializePipelineGroupReceiver(item, options));
                            }
                            receivers = array;
                            continue;
                        }
                        if (property0.NameEquals("processors"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PipelineGroupProcessor> array = new List<PipelineGroupProcessor>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PipelineGroupProcessor.DeserializePipelineGroupProcessor(item, options));
                            }
                            processors = array;
                            continue;
                        }
                        if (property0.NameEquals("exporters"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PipelineGroupExporter> array = new List<PipelineGroupExporter>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PipelineGroupExporter.DeserializePipelineGroupExporter(item, options));
                            }
                            exporters = array;
                            continue;
                        }
                        if (property0.NameEquals("service"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            service = PipelineGroupService.DeserializePipelineGroupService(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("networkingConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PipelineGroupNetworkingConfiguration> array = new List<PipelineGroupNetworkingConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PipelineGroupNetworkingConfiguration.DeserializePipelineGroupNetworkingConfiguration(item, options));
                            }
                            networkingConfigurations = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PipelineGroupPatch(
                tags ?? new ChangeTrackingDictionary<string, string>(),
                replicas,
                receivers ?? new ChangeTrackingList<PipelineGroupReceiver>(),
                processors ?? new ChangeTrackingList<PipelineGroupProcessor>(),
                exporters ?? new ChangeTrackingList<PipelineGroupExporter>(),
                service,
                networkingConfigurations ?? new ChangeTrackingList<PipelineGroupNetworkingConfiguration>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PipelineGroupPatch>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineGroupPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PipelineGroupPatch)} does not support writing '{options.Format}' format.");
            }
        }

        PipelineGroupPatch IPersistableModel<PipelineGroupPatch>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineGroupPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePipelineGroupPatch(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PipelineGroupPatch)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PipelineGroupPatch>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
