// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Networking route configuration. </summary>
    public partial class PipelineGroupNetworkingRoute
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupNetworkingRoute"/>. </summary>
        /// <param name="receiver"> The name of the previously defined receiver. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="receiver"/> is null. </exception>
        public PipelineGroupNetworkingRoute(string receiver)
        {
            Argument.AssertNotNull(receiver, nameof(receiver));

            Receiver = receiver;
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupNetworkingRoute"/>. </summary>
        /// <param name="receiver"> The name of the previously defined receiver. </param>
        /// <param name="port"> The port that will be configured externally. If not specified, it will use the port from the receiver definition. </param>
        /// <param name="path"> Route path. </param>
        /// <param name="subdomain"> Route subdomain. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PipelineGroupNetworkingRoute(string receiver, int? port, string path, string subdomain, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Receiver = receiver;
            Port = port;
            Path = path;
            Subdomain = subdomain;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PipelineGroupNetworkingRoute"/> for deserialization. </summary>
        internal PipelineGroupNetworkingRoute()
        {
        }

        /// <summary> The name of the previously defined receiver. </summary>
        public string Receiver { get; set; }
        /// <summary> The port that will be configured externally. If not specified, it will use the port from the receiver definition. </summary>
        public int? Port { get; set; }
        /// <summary> Route path. </summary>
        public string Path { get; set; }
        /// <summary> Route subdomain. </summary>
        public string Subdomain { get; set; }
    }
}
