// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The mode of the external networking. </summary>
    public readonly partial struct PipelineGroupExternalNetworkingMode : IEquatable<PipelineGroupExternalNetworkingMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupExternalNetworkingMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PipelineGroupExternalNetworkingMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LoadBalancerOnlyValue = "LoadBalancerOnly";

        /// <summary> Load balancer only. </summary>
        public static PipelineGroupExternalNetworkingMode LoadBalancerOnly { get; } = new PipelineGroupExternalNetworkingMode(LoadBalancerOnlyValue);
        /// <summary> Determines if two <see cref="PipelineGroupExternalNetworkingMode"/> values are the same. </summary>
        public static bool operator ==(PipelineGroupExternalNetworkingMode left, PipelineGroupExternalNetworkingMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PipelineGroupExternalNetworkingMode"/> values are not the same. </summary>
        public static bool operator !=(PipelineGroupExternalNetworkingMode left, PipelineGroupExternalNetworkingMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PipelineGroupExternalNetworkingMode"/>. </summary>
        public static implicit operator PipelineGroupExternalNetworkingMode(string value) => new PipelineGroupExternalNetworkingMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PipelineGroupExternalNetworkingMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PipelineGroupExternalNetworkingMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
