// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The exporter type. </summary>
    public readonly partial struct PipelineGroupExporterType : IEquatable<PipelineGroupExporterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PipelineGroupExporterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PipelineGroupExporterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureMonitorWorkspaceLogsValue = "AzureMonitorWorkspaceLogs";
        private const string PipelineGroupValue = "PipelineGroup";

        /// <summary> Export logs to Azure Monitor Workspace. </summary>
        public static PipelineGroupExporterType AzureMonitorWorkspaceLogs { get; } = new PipelineGroupExporterType(AzureMonitorWorkspaceLogsValue);
        /// <summary> Export data to another pipeline group instance. </summary>
        public static PipelineGroupExporterType PipelineGroup { get; } = new PipelineGroupExporterType(PipelineGroupValue);
        /// <summary> Determines if two <see cref="PipelineGroupExporterType"/> values are the same. </summary>
        public static bool operator ==(PipelineGroupExporterType left, PipelineGroupExporterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PipelineGroupExporterType"/> values are not the same. </summary>
        public static bool operator !=(PipelineGroupExporterType left, PipelineGroupExporterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PipelineGroupExporterType"/>. </summary>
        public static implicit operator PipelineGroupExporterType(string value) => new PipelineGroupExporterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PipelineGroupExporterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PipelineGroupExporterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
