// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Information about metrics for the workspace. </summary>
    public partial class MonitorWorkspaceMetricProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceMetricProperties"/>. </summary>
        public MonitorWorkspaceMetricProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceMetricProperties"/>. </summary>
        /// <param name="prometheusQueryEndpoint"> The Prometheus query endpoint for the workspace. </param>
        /// <param name="internalId"> An internal identifier for the metrics container. Only to be used by the system. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorWorkspaceMetricProperties(string prometheusQueryEndpoint, string internalId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrometheusQueryEndpoint = prometheusQueryEndpoint;
            InternalId = internalId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Prometheus query endpoint for the workspace. </summary>
        public string PrometheusQueryEndpoint { get; }
        /// <summary> An internal identifier for the metrics container. Only to be used by the system. </summary>
        public string InternalId { get; }
    }
}
