// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Schema map for azure monitor for logs. </summary>
    public partial class MonitorWorkspaceLogsSchemaMap
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsSchemaMap"/>. </summary>
        /// <param name="recordMap"> Record Map. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="recordMap"/> is null. </exception>
        public MonitorWorkspaceLogsSchemaMap(IEnumerable<MonitorWorkspaceLogsRecordMap> recordMap)
        {
            Argument.AssertNotNull(recordMap, nameof(recordMap));

            RecordMap = recordMap.ToList();
            ResourceMap = new ChangeTrackingList<MonitorWorkspaceLogsResourceMap>();
            ScopeMap = new ChangeTrackingList<MonitorWorkspaceLogsScopeMap>();
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsSchemaMap"/>. </summary>
        /// <param name="recordMap"> Record Map. </param>
        /// <param name="resourceMap"> Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process. </param>
        /// <param name="scopeMap"> A scope map is a logical unit of the application code with which the emitted telemetry can be associated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorWorkspaceLogsSchemaMap(IList<MonitorWorkspaceLogsRecordMap> recordMap, IList<MonitorWorkspaceLogsResourceMap> resourceMap, IList<MonitorWorkspaceLogsScopeMap> scopeMap, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RecordMap = recordMap;
            ResourceMap = resourceMap;
            ScopeMap = scopeMap;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsSchemaMap"/> for deserialization. </summary>
        internal MonitorWorkspaceLogsSchemaMap()
        {
        }

        /// <summary> Record Map. </summary>
        public IList<MonitorWorkspaceLogsRecordMap> RecordMap { get; }
        /// <summary> Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process. </summary>
        public IList<MonitorWorkspaceLogsResourceMap> ResourceMap { get; }
        /// <summary> A scope map is a logical unit of the application code with which the emitted telemetry can be associated. </summary>
        public IList<MonitorWorkspaceLogsScopeMap> ScopeMap { get; }
    }
}
