// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Monitor.Models
{
    public partial class MonitorWorkspaceLogsSchemaMap : IUtf8JsonSerializable, IJsonModel<MonitorWorkspaceLogsSchemaMap>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MonitorWorkspaceLogsSchemaMap>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MonitorWorkspaceLogsSchemaMap>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorWorkspaceLogsSchemaMap>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorWorkspaceLogsSchemaMap)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("recordMap"u8);
            writer.WriteStartArray();
            foreach (var item in RecordMap)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (Optional.IsCollectionDefined(ResourceMap))
            {
                writer.WritePropertyName("resourceMap"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceMap)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ScopeMap))
            {
                writer.WritePropertyName("scopeMap"u8);
                writer.WriteStartArray();
                foreach (var item in ScopeMap)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MonitorWorkspaceLogsSchemaMap IJsonModel<MonitorWorkspaceLogsSchemaMap>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorWorkspaceLogsSchemaMap>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorWorkspaceLogsSchemaMap)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMonitorWorkspaceLogsSchemaMap(document.RootElement, options);
        }

        internal static MonitorWorkspaceLogsSchemaMap DeserializeMonitorWorkspaceLogsSchemaMap(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<MonitorWorkspaceLogsRecordMap> recordMap = default;
            IList<MonitorWorkspaceLogsResourceMap> resourceMap = default;
            IList<MonitorWorkspaceLogsScopeMap> scopeMap = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("recordMap"u8))
                {
                    List<MonitorWorkspaceLogsRecordMap> array = new List<MonitorWorkspaceLogsRecordMap>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MonitorWorkspaceLogsRecordMap.DeserializeMonitorWorkspaceLogsRecordMap(item, options));
                    }
                    recordMap = array;
                    continue;
                }
                if (property.NameEquals("resourceMap"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MonitorWorkspaceLogsResourceMap> array = new List<MonitorWorkspaceLogsResourceMap>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MonitorWorkspaceLogsResourceMap.DeserializeMonitorWorkspaceLogsResourceMap(item, options));
                    }
                    resourceMap = array;
                    continue;
                }
                if (property.NameEquals("scopeMap"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MonitorWorkspaceLogsScopeMap> array = new List<MonitorWorkspaceLogsScopeMap>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MonitorWorkspaceLogsScopeMap.DeserializeMonitorWorkspaceLogsScopeMap(item, options));
                    }
                    scopeMap = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MonitorWorkspaceLogsSchemaMap(recordMap, resourceMap ?? new ChangeTrackingList<MonitorWorkspaceLogsResourceMap>(), scopeMap ?? new ChangeTrackingList<MonitorWorkspaceLogsScopeMap>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MonitorWorkspaceLogsSchemaMap>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorWorkspaceLogsSchemaMap>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MonitorWorkspaceLogsSchemaMap)} does not support writing '{options.Format}' format.");
            }
        }

        MonitorWorkspaceLogsSchemaMap IPersistableModel<MonitorWorkspaceLogsSchemaMap>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorWorkspaceLogsSchemaMap>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMonitorWorkspaceLogsSchemaMap(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MonitorWorkspaceLogsSchemaMap)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MonitorWorkspaceLogsSchemaMap>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
