// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Resource map for schema in azure monitor. </summary>
    public partial class MonitorWorkspaceLogsResourceMap
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsResourceMap"/>. </summary>
        /// <param name="from"> Resource Map Key. </param>
        /// <param name="to"> Resource Map Value. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="from"/> or <paramref name="to"/> is null. </exception>
        public MonitorWorkspaceLogsResourceMap(string @from, string to)
        {
            Argument.AssertNotNull(@from, nameof(@from));
            Argument.AssertNotNull(to, nameof(to));

            From = @from;
            To = to;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsResourceMap"/>. </summary>
        /// <param name="from"> Resource Map Key. </param>
        /// <param name="to"> Resource Map Value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorWorkspaceLogsResourceMap(string @from, string to, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            From = @from;
            To = to;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsResourceMap"/> for deserialization. </summary>
        internal MonitorWorkspaceLogsResourceMap()
        {
        }

        /// <summary> Resource Map Key. </summary>
        public string From { get; set; }
        /// <summary> Resource Map Value. </summary>
        public string To { get; set; }
    }
}
