// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Concurrent publishing configuration. </summary>
    public partial class MonitorWorkspaceLogsExporterConcurrencyConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsExporterConcurrencyConfiguration"/>. </summary>
        public MonitorWorkspaceLogsExporterConcurrencyConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsExporterConcurrencyConfiguration"/>. </summary>
        /// <param name="workerCount"> Number of parallel workers processing the log queues. </param>
        /// <param name="batchQueueSize"> Size of the queue for log batches. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorWorkspaceLogsExporterConcurrencyConfiguration(int? workerCount, int? batchQueueSize, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WorkerCount = workerCount;
            BatchQueueSize = batchQueueSize;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Number of parallel workers processing the log queues. </summary>
        public int? WorkerCount { get; set; }
        /// <summary> Size of the queue for log batches. </summary>
        public int? BatchQueueSize { get; set; }
    }
}
