// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Cache configurations. </summary>
    public partial class MonitorWorkspaceLogsExporterCacheConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsExporterCacheConfiguration"/>. </summary>
        public MonitorWorkspaceLogsExporterCacheConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsExporterCacheConfiguration"/>. </summary>
        /// <param name="maxStorageUsage"> Max storage usage in megabytes. </param>
        /// <param name="retentionPeriod"> Retention period in minutes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorWorkspaceLogsExporterCacheConfiguration(int? maxStorageUsage, int? retentionPeriod, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MaxStorageUsage = maxStorageUsage;
            RetentionPeriod = retentionPeriod;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Max storage usage in megabytes. </summary>
        public int? MaxStorageUsage { get; set; }
        /// <summary> Retention period in minutes. </summary>
        public int? RetentionPeriod { get; set; }
    }
}
