// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Azure Monitor Workspace Logs specific configurations. </summary>
    public partial class MonitorWorkspaceLogsExporter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsExporter"/>. </summary>
        /// <param name="api"> API configurations for Azure Monitor workspace exporter. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="api"/> is null. </exception>
        public MonitorWorkspaceLogsExporter(MonitorWorkspaceLogsApiConfig api)
        {
            Argument.AssertNotNull(api, nameof(api));

            Api = api;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsExporter"/>. </summary>
        /// <param name="api"> API configurations for Azure Monitor workspace exporter. </param>
        /// <param name="concurrency"> Concurrency configuration for the exporter. </param>
        /// <param name="cache"> Cache configurations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorWorkspaceLogsExporter(MonitorWorkspaceLogsApiConfig api, MonitorWorkspaceLogsExporterConcurrencyConfiguration concurrency, MonitorWorkspaceLogsExporterCacheConfiguration cache, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Api = api;
            Concurrency = concurrency;
            Cache = cache;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorWorkspaceLogsExporter"/> for deserialization. </summary>
        internal MonitorWorkspaceLogsExporter()
        {
        }

        /// <summary> API configurations for Azure Monitor workspace exporter. </summary>
        public MonitorWorkspaceLogsApiConfig Api { get; set; }
        /// <summary> Concurrency configuration for the exporter. </summary>
        public MonitorWorkspaceLogsExporterConcurrencyConfiguration Concurrency { get; set; }
        /// <summary> Cache configurations. </summary>
        public MonitorWorkspaceLogsExporterCacheConfiguration Cache { get; set; }
    }
}
