// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Monitor.Models
{
    public partial class MonitorWorkspaceLogsExporter : IUtf8JsonSerializable, IJsonModel<MonitorWorkspaceLogsExporter>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MonitorWorkspaceLogsExporter>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MonitorWorkspaceLogsExporter>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorWorkspaceLogsExporter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorWorkspaceLogsExporter)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("api"u8);
            writer.WriteObjectValue(Api, options);
            if (Optional.IsDefined(Concurrency))
            {
                writer.WritePropertyName("concurrency"u8);
                writer.WriteObjectValue(Concurrency, options);
            }
            if (Optional.IsDefined(Cache))
            {
                writer.WritePropertyName("cache"u8);
                writer.WriteObjectValue(Cache, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MonitorWorkspaceLogsExporter IJsonModel<MonitorWorkspaceLogsExporter>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorWorkspaceLogsExporter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorWorkspaceLogsExporter)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMonitorWorkspaceLogsExporter(document.RootElement, options);
        }

        internal static MonitorWorkspaceLogsExporter DeserializeMonitorWorkspaceLogsExporter(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MonitorWorkspaceLogsApiConfig api = default;
            MonitorWorkspaceLogsExporterConcurrencyConfiguration concurrency = default;
            MonitorWorkspaceLogsExporterCacheConfiguration cache = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("api"u8))
                {
                    api = MonitorWorkspaceLogsApiConfig.DeserializeMonitorWorkspaceLogsApiConfig(property.Value, options);
                    continue;
                }
                if (property.NameEquals("concurrency"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    concurrency = MonitorWorkspaceLogsExporterConcurrencyConfiguration.DeserializeMonitorWorkspaceLogsExporterConcurrencyConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("cache"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cache = MonitorWorkspaceLogsExporterCacheConfiguration.DeserializeMonitorWorkspaceLogsExporterCacheConfiguration(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MonitorWorkspaceLogsExporter(api, concurrency, cache, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MonitorWorkspaceLogsExporter>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorWorkspaceLogsExporter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MonitorWorkspaceLogsExporter)} does not support writing '{options.Format}' format.");
            }
        }

        MonitorWorkspaceLogsExporter IPersistableModel<MonitorWorkspaceLogsExporter>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorWorkspaceLogsExporter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMonitorWorkspaceLogsExporter(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MonitorWorkspaceLogsExporter)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MonitorWorkspaceLogsExporter>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
