// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> An SMS receiver. </summary>
    public partial class MonitorSmsReceiver
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorSmsReceiver"/>. </summary>
        /// <param name="name"> The name of the SMS receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="countryCode"> The country code of the SMS receiver. </param>
        /// <param name="phoneNumber"> The phone number of the SMS receiver. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/>, <paramref name="countryCode"/> or <paramref name="phoneNumber"/> is null. </exception>
        public MonitorSmsReceiver(string name, string countryCode, string phoneNumber)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(countryCode, nameof(countryCode));
            Argument.AssertNotNull(phoneNumber, nameof(phoneNumber));

            Name = name;
            CountryCode = countryCode;
            PhoneNumber = phoneNumber;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorSmsReceiver"/>. </summary>
        /// <param name="name"> The name of the SMS receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="countryCode"> The country code of the SMS receiver. </param>
        /// <param name="phoneNumber"> The phone number of the SMS receiver. </param>
        /// <param name="status"> The status of the receiver. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorSmsReceiver(string name, string countryCode, string phoneNumber, MonitorReceiverStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            CountryCode = countryCode;
            PhoneNumber = phoneNumber;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorSmsReceiver"/> for deserialization. </summary>
        internal MonitorSmsReceiver()
        {
        }

        /// <summary> The name of the SMS receiver. Names must be unique across all receivers within an action group. </summary>
        public string Name { get; set; }
        /// <summary> The country code of the SMS receiver. </summary>
        public string CountryCode { get; set; }
        /// <summary> The phone number of the SMS receiver. </summary>
        public string PhoneNumber { get; set; }
        /// <summary> The status of the receiver. </summary>
        public MonitorReceiverStatus? Status { get; }
    }
}
