// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Monitor.Models
{
    public partial class MonitorSingleBaseline : IUtf8JsonSerializable, IJsonModel<MonitorSingleBaseline>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MonitorSingleBaseline>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MonitorSingleBaseline>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorSingleBaseline>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorSingleBaseline)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("sensitivity"u8);
            writer.WriteStringValue(Sensitivity.ToString());
            writer.WritePropertyName("lowThresholds"u8);
            writer.WriteStartArray();
            foreach (var item in LowThresholds)
            {
                writer.WriteNumberValue(item);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("highThresholds"u8);
            writer.WriteStartArray();
            foreach (var item in HighThresholds)
            {
                writer.WriteNumberValue(item);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MonitorSingleBaseline IJsonModel<MonitorSingleBaseline>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorSingleBaseline>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorSingleBaseline)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMonitorSingleBaseline(document.RootElement, options);
        }

        internal static MonitorSingleBaseline DeserializeMonitorSingleBaseline(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MonitorBaselineSensitivity sensitivity = default;
            IReadOnlyList<double> lowThresholds = default;
            IReadOnlyList<double> highThresholds = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sensitivity"u8))
                {
                    sensitivity = new MonitorBaselineSensitivity(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lowThresholds"u8))
                {
                    List<double> array = new List<double>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetDouble());
                    }
                    lowThresholds = array;
                    continue;
                }
                if (property.NameEquals("highThresholds"u8))
                {
                    List<double> array = new List<double>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetDouble());
                    }
                    highThresholds = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MonitorSingleBaseline(sensitivity, lowThresholds, highThresholds, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MonitorSingleBaseline>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorSingleBaseline>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MonitorSingleBaseline)} does not support writing '{options.Format}' format.");
            }
        }

        MonitorSingleBaseline IPersistableModel<MonitorSingleBaseline>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorSingleBaseline>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMonitorSingleBaseline(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MonitorSingleBaseline)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MonitorSingleBaseline>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
