// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Monitor.Models
{
    internal static partial class MonitorScaleTypeExtensions
    {
        public static string ToSerialString(this MonitorScaleType value) => value switch
        {
            MonitorScaleType.ChangeCount => "ChangeCount",
            MonitorScaleType.PercentChangeCount => "PercentChangeCount",
            MonitorScaleType.ExactCount => "ExactCount",
            MonitorScaleType.ServiceAllowedNextValue => "ServiceAllowedNextValue",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MonitorScaleType value.")
        };

        public static MonitorScaleType ToMonitorScaleType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ChangeCount")) return MonitorScaleType.ChangeCount;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PercentChangeCount")) return MonitorScaleType.PercentChangeCount;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ExactCount")) return MonitorScaleType.ExactCount;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ServiceAllowedNextValue")) return MonitorScaleType.ServiceAllowedNextValue;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MonitorScaleType value.");
        }
    }
}
