// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The number of instances that can be used during this profile. </summary>
    public partial class MonitorScaleCapacity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorScaleCapacity"/>. </summary>
        /// <param name="minimum"> the minimum number of instances for the resource. </param>
        /// <param name="maximum"> the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription. </param>
        /// <param name="default"> the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default. </param>
        public MonitorScaleCapacity(int minimum, int maximum, int @default)
        {
            Minimum = minimum;
            Maximum = maximum;
            Default = @default;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorScaleCapacity"/>. </summary>
        /// <param name="minimum"> the minimum number of instances for the resource. </param>
        /// <param name="maximum"> the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription. </param>
        /// <param name="default"> the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorScaleCapacity(int minimum, int maximum, int @default, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Minimum = minimum;
            Maximum = maximum;
            Default = @default;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorScaleCapacity"/> for deserialization. </summary>
        internal MonitorScaleCapacity()
        {
        }

        /// <summary> the minimum number of instances for the resource. </summary>
        public int Minimum { get; set; }
        /// <summary> the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription. </summary>
        public int Maximum { get; set; }
        /// <summary> the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default. </summary>
        public int Default { get; set; }
    }
}
