// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The parameters for the scaling action. </summary>
    public partial class MonitorScaleAction
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorScaleAction"/>. </summary>
        /// <param name="direction"> the scale direction. Whether the scaling action increases or decreases the number of instances. </param>
        /// <param name="scaleType"> the type of action that should occur when the scale rule fires. </param>
        /// <param name="cooldown"> the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format. </param>
        public MonitorScaleAction(MonitorScaleDirection direction, MonitorScaleType scaleType, TimeSpan cooldown)
        {
            Direction = direction;
            ScaleType = scaleType;
            Cooldown = cooldown;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorScaleAction"/>. </summary>
        /// <param name="direction"> the scale direction. Whether the scaling action increases or decreases the number of instances. </param>
        /// <param name="scaleType"> the type of action that should occur when the scale rule fires. </param>
        /// <param name="value"> the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1. </param>
        /// <param name="cooldown"> the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorScaleAction(MonitorScaleDirection direction, MonitorScaleType scaleType, string value, TimeSpan cooldown, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Direction = direction;
            ScaleType = scaleType;
            Value = value;
            Cooldown = cooldown;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorScaleAction"/> for deserialization. </summary>
        internal MonitorScaleAction()
        {
        }

        /// <summary> the scale direction. Whether the scaling action increases or decreases the number of instances. </summary>
        public MonitorScaleDirection Direction { get; set; }
        /// <summary> the type of action that should occur when the scale rule fires. </summary>
        public MonitorScaleType ScaleType { get; set; }
        /// <summary> the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1. </summary>
        public string Value { get; set; }
        /// <summary> the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format. </summary>
        public TimeSpan Cooldown { get; set; }
    }
}
