// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Monitor.Models
{
    internal static partial class MonitorResultTypeExtensions
    {
        public static string ToSerialString(this MonitorResultType value) => value switch
        {
            MonitorResultType.Data => "Data",
            MonitorResultType.Metadata => "Metadata",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MonitorResultType value.")
        };

        public static MonitorResultType ToMonitorResultType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Data")) return MonitorResultType.Data;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Metadata")) return MonitorResultType.Metadata;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MonitorResultType value.");
        }
    }
}
