// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The repeating times at which this profile begins. This element is not used if the FixedDate element is used. </summary>
    public partial class MonitorRecurrence
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorRecurrence"/>. </summary>
        /// <param name="frequency"> the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly. </param>
        /// <param name="schedule"> the scheduling constraints for when the profile begins. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="schedule"/> is null. </exception>
        public MonitorRecurrence(RecurrenceFrequency frequency, RecurrentSchedule schedule)
        {
            Argument.AssertNotNull(schedule, nameof(schedule));

            Frequency = frequency;
            Schedule = schedule;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorRecurrence"/>. </summary>
        /// <param name="frequency"> the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly. </param>
        /// <param name="schedule"> the scheduling constraints for when the profile begins. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorRecurrence(RecurrenceFrequency frequency, RecurrentSchedule schedule, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Frequency = frequency;
            Schedule = schedule;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorRecurrence"/> for deserialization. </summary>
        internal MonitorRecurrence()
        {
        }

        /// <summary> the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly. </summary>
        public RecurrenceFrequency Frequency { get; set; }
        /// <summary> the scheduling constraints for when the profile begins. </summary>
        public RecurrentSchedule Schedule { get; set; }
    }
}
