// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Monitor.Models
{
    internal static partial class MonitorReceiverStatusExtensions
    {
        public static string ToSerialString(this MonitorReceiverStatus value) => value switch
        {
            MonitorReceiverStatus.NotSpecified => "NotSpecified",
            MonitorReceiverStatus.Enabled => "Enabled",
            MonitorReceiverStatus.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MonitorReceiverStatus value.")
        };

        public static MonitorReceiverStatus ToMonitorReceiverStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotSpecified")) return MonitorReceiverStatus.NotSpecified;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return MonitorReceiverStatus.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return MonitorReceiverStatus.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MonitorReceiverStatus value.");
        }
    }
}
