// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The configuration to set whether network access from public internet to the endpoints are allowed. </summary>
    public readonly partial struct MonitorPublicNetworkAccess : IEquatable<MonitorPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string SecuredByPerimeterValue = "SecuredByPerimeter";

        /// <summary> Enabled. </summary>
        public static MonitorPublicNetworkAccess Enabled { get; } = new MonitorPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static MonitorPublicNetworkAccess Disabled { get; } = new MonitorPublicNetworkAccess(DisabledValue);
        /// <summary> SecuredByPerimeter. </summary>
        public static MonitorPublicNetworkAccess SecuredByPerimeter { get; } = new MonitorPublicNetworkAccess(SecuredByPerimeterValue);
        /// <summary> Determines if two <see cref="MonitorPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(MonitorPublicNetworkAccess left, MonitorPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(MonitorPublicNetworkAccess left, MonitorPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorPublicNetworkAccess"/>. </summary>
        public static implicit operator MonitorPublicNetworkAccess(string value) => new MonitorPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
