// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The status of operation. </summary>
    public partial class MonitorPrivateLinkScopeOperationStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorPrivateLinkScopeOperationStatus"/>. </summary>
        internal MonitorPrivateLinkScopeOperationStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MonitorPrivateLinkScopeOperationStatus"/>. </summary>
        /// <param name="id"> The operation Id. </param>
        /// <param name="name"> The operation name. </param>
        /// <param name="startOn"> Start time of the job in standard ISO8601 format. </param>
        /// <param name="endOn"> End time of the job in standard ISO8601 format. </param>
        /// <param name="status"> The status of the operation. </param>
        /// <param name="error"> The error detail of the operation if any. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorPrivateLinkScopeOperationStatus(string id, string name, DateTimeOffset? startOn, DateTimeOffset? endOn, string status, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            StartOn = startOn;
            EndOn = endOn;
            Status = status;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The operation Id. </summary>
        public string Id { get; }
        /// <summary> The operation name. </summary>
        public string Name { get; }
        /// <summary> Start time of the job in standard ISO8601 format. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> End time of the job in standard ISO8601 format. </summary>
        public DateTimeOffset? EndOn { get; }
        /// <summary> The status of the operation. </summary>
        public string Status { get; }
        /// <summary> The error detail of the operation if any. </summary>
        public ResponseError Error { get; }
    }
}
