// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Properties that define the scope private link mode settings exclusion item. This setting applies to a specific private endpoint connection and overrides the default settings for that private endpoint connection. </summary>
    public partial class MonitorPrivateLinkAccessModeSettingsExclusion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorPrivateLinkAccessModeSettingsExclusion"/>. </summary>
        public MonitorPrivateLinkAccessModeSettingsExclusion()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MonitorPrivateLinkAccessModeSettingsExclusion"/>. </summary>
        /// <param name="privateEndpointConnectionName"> The private endpoint connection name associated to the private endpoint on which we want to apply the specific access mode settings. </param>
        /// <param name="queryAccessMode"> Specifies the access mode of queries through the specified private endpoint connection in the exclusion. </param>
        /// <param name="ingestionAccessMode"> Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorPrivateLinkAccessModeSettingsExclusion(string privateEndpointConnectionName, MonitorPrivateLinkAccessMode? queryAccessMode, MonitorPrivateLinkAccessMode? ingestionAccessMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrivateEndpointConnectionName = privateEndpointConnectionName;
            QueryAccessMode = queryAccessMode;
            IngestionAccessMode = ingestionAccessMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The private endpoint connection name associated to the private endpoint on which we want to apply the specific access mode settings. </summary>
        public string PrivateEndpointConnectionName { get; set; }
        /// <summary> Specifies the access mode of queries through the specified private endpoint connection in the exclusion. </summary>
        public MonitorPrivateLinkAccessMode? QueryAccessMode { get; set; }
        /// <summary> Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion. </summary>
        public MonitorPrivateLinkAccessMode? IngestionAccessMode { get; set; }
    }
}
