// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Monitor.Models
{
    public partial class MonitorPrivateLinkAccessModeSettingsExclusion : IUtf8JsonSerializable, IJsonModel<MonitorPrivateLinkAccessModeSettingsExclusion>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MonitorPrivateLinkAccessModeSettingsExclusion>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MonitorPrivateLinkAccessModeSettingsExclusion>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorPrivateLinkAccessModeSettingsExclusion>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorPrivateLinkAccessModeSettingsExclusion)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(PrivateEndpointConnectionName))
            {
                writer.WritePropertyName("privateEndpointConnectionName"u8);
                writer.WriteStringValue(PrivateEndpointConnectionName);
            }
            if (Optional.IsDefined(QueryAccessMode))
            {
                writer.WritePropertyName("queryAccessMode"u8);
                writer.WriteStringValue(QueryAccessMode.Value.ToString());
            }
            if (Optional.IsDefined(IngestionAccessMode))
            {
                writer.WritePropertyName("ingestionAccessMode"u8);
                writer.WriteStringValue(IngestionAccessMode.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MonitorPrivateLinkAccessModeSettingsExclusion IJsonModel<MonitorPrivateLinkAccessModeSettingsExclusion>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorPrivateLinkAccessModeSettingsExclusion>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorPrivateLinkAccessModeSettingsExclusion)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMonitorPrivateLinkAccessModeSettingsExclusion(document.RootElement, options);
        }

        internal static MonitorPrivateLinkAccessModeSettingsExclusion DeserializeMonitorPrivateLinkAccessModeSettingsExclusion(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string privateEndpointConnectionName = default;
            MonitorPrivateLinkAccessMode? queryAccessMode = default;
            MonitorPrivateLinkAccessMode? ingestionAccessMode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("privateEndpointConnectionName"u8))
                {
                    privateEndpointConnectionName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("queryAccessMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    queryAccessMode = new MonitorPrivateLinkAccessMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("ingestionAccessMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ingestionAccessMode = new MonitorPrivateLinkAccessMode(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MonitorPrivateLinkAccessModeSettingsExclusion(privateEndpointConnectionName, queryAccessMode, ingestionAccessMode, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MonitorPrivateLinkAccessModeSettingsExclusion>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorPrivateLinkAccessModeSettingsExclusion>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MonitorPrivateLinkAccessModeSettingsExclusion)} does not support writing '{options.Format}' format.");
            }
        }

        MonitorPrivateLinkAccessModeSettingsExclusion IPersistableModel<MonitorPrivateLinkAccessModeSettingsExclusion>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorPrivateLinkAccessModeSettingsExclusion>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMonitorPrivateLinkAccessModeSettingsExclusion(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MonitorPrivateLinkAccessModeSettingsExclusion)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MonitorPrivateLinkAccessModeSettingsExclusion>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
