// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> specifies the type of the alert criteria. </summary>
    internal readonly partial struct MonitorOdataType : IEquatable<MonitorOdataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorOdataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorOdataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftAzureMonitorSingleResourceMultipleMetricCriteriaValue = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria";
        private const string MicrosoftAzureMonitorMultipleResourceMultipleMetricCriteriaValue = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria";
        private const string MicrosoftAzureMonitorWebtestLocationAvailabilityCriteriaValue = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria";

        /// <summary> Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria. </summary>
        public static MonitorOdataType MicrosoftAzureMonitorSingleResourceMultipleMetricCriteria { get; } = new MonitorOdataType(MicrosoftAzureMonitorSingleResourceMultipleMetricCriteriaValue);
        /// <summary> Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria. </summary>
        public static MonitorOdataType MicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria { get; } = new MonitorOdataType(MicrosoftAzureMonitorMultipleResourceMultipleMetricCriteriaValue);
        /// <summary> Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria. </summary>
        public static MonitorOdataType MicrosoftAzureMonitorWebtestLocationAvailabilityCriteria { get; } = new MonitorOdataType(MicrosoftAzureMonitorWebtestLocationAvailabilityCriteriaValue);
        /// <summary> Determines if two <see cref="MonitorOdataType"/> values are the same. </summary>
        public static bool operator ==(MonitorOdataType left, MonitorOdataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorOdataType"/> values are not the same. </summary>
        public static bool operator !=(MonitorOdataType left, MonitorOdataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorOdataType"/>. </summary>
        public static implicit operator MonitorOdataType(string value) => new MonitorOdataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorOdataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorOdataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
