// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Kind of namespace. </summary>
    public readonly partial struct MonitorNamespaceClassification : IEquatable<MonitorNamespaceClassification>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorNamespaceClassification"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorNamespaceClassification(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PlatformValue = "Platform";
        private const string CustomValue = "Custom";
        private const string QosValue = "Qos";

        /// <summary> Platform. </summary>
        public static MonitorNamespaceClassification Platform { get; } = new MonitorNamespaceClassification(PlatformValue);
        /// <summary> Custom. </summary>
        public static MonitorNamespaceClassification Custom { get; } = new MonitorNamespaceClassification(CustomValue);
        /// <summary> Qos. </summary>
        public static MonitorNamespaceClassification Qos { get; } = new MonitorNamespaceClassification(QosValue);
        /// <summary> Determines if two <see cref="MonitorNamespaceClassification"/> values are the same. </summary>
        public static bool operator ==(MonitorNamespaceClassification left, MonitorNamespaceClassification right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorNamespaceClassification"/> values are not the same. </summary>
        public static bool operator !=(MonitorNamespaceClassification left, MonitorNamespaceClassification right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorNamespaceClassification"/>. </summary>
        public static implicit operator MonitorNamespaceClassification(string value) => new MonitorNamespaceClassification(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorNamespaceClassification other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorNamespaceClassification other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
