// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Represents a metric value. </summary>
    public partial class MonitorMetricValue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorMetricValue"/>. </summary>
        /// <param name="timeStamp"> the timestamp for the metric value in ISO 8601 format. </param>
        internal MonitorMetricValue(DateTimeOffset timeStamp)
        {
            TimeStamp = timeStamp;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorMetricValue"/>. </summary>
        /// <param name="timeStamp"> the timestamp for the metric value in ISO 8601 format. </param>
        /// <param name="average"> the average value in the time range. </param>
        /// <param name="minimum"> the least value in the time range. </param>
        /// <param name="maximum"> the greatest value in the time range. </param>
        /// <param name="total"> the sum of all of the values in the time range. </param>
        /// <param name="count"> the number of samples in the time range. Can be used to determine the number of values that contributed to the average value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorMetricValue(DateTimeOffset timeStamp, double? average, double? minimum, double? maximum, double? total, double? count, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TimeStamp = timeStamp;
            Average = average;
            Minimum = minimum;
            Maximum = maximum;
            Total = total;
            Count = count;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorMetricValue"/> for deserialization. </summary>
        internal MonitorMetricValue()
        {
        }

        /// <summary> the timestamp for the metric value in ISO 8601 format. </summary>
        public DateTimeOffset TimeStamp { get; }
        /// <summary> the average value in the time range. </summary>
        public double? Average { get; }
        /// <summary> the least value in the time range. </summary>
        public double? Minimum { get; }
        /// <summary> the greatest value in the time range. </summary>
        public double? Maximum { get; }
        /// <summary> the sum of all of the values in the time range. </summary>
        public double? Total { get; }
        /// <summary> the number of samples in the time range. Can be used to determine the number of values that contributed to the average value. </summary>
        public double? Count { get; }
    }
}
