// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The unit of the metric. </summary>
    public readonly partial struct MonitorMetricUnit : IEquatable<MonitorMetricUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorMetricUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorMetricUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "Count";
        private const string BytesValue = "Bytes";
        private const string SecondsValue = "Seconds";
        private const string CountPerSecondValue = "CountPerSecond";
        private const string BytesPerSecondValue = "BytesPerSecond";
        private const string PercentValue = "Percent";
        private const string MilliSecondsValue = "MilliSeconds";
        private const string ByteSecondsValue = "ByteSeconds";
        private const string UnspecifiedValue = "Unspecified";
        private const string CoresValue = "Cores";
        private const string MilliCoresValue = "MilliCores";
        private const string NanoCoresValue = "NanoCores";
        private const string BitsPerSecondValue = "BitsPerSecond";

        /// <summary> Count. </summary>
        public static MonitorMetricUnit Count { get; } = new MonitorMetricUnit(CountValue);
        /// <summary> Bytes. </summary>
        public static MonitorMetricUnit Bytes { get; } = new MonitorMetricUnit(BytesValue);
        /// <summary> Seconds. </summary>
        public static MonitorMetricUnit Seconds { get; } = new MonitorMetricUnit(SecondsValue);
        /// <summary> CountPerSecond. </summary>
        public static MonitorMetricUnit CountPerSecond { get; } = new MonitorMetricUnit(CountPerSecondValue);
        /// <summary> BytesPerSecond. </summary>
        public static MonitorMetricUnit BytesPerSecond { get; } = new MonitorMetricUnit(BytesPerSecondValue);
        /// <summary> Percent. </summary>
        public static MonitorMetricUnit Percent { get; } = new MonitorMetricUnit(PercentValue);
        /// <summary> MilliSeconds. </summary>
        public static MonitorMetricUnit MilliSeconds { get; } = new MonitorMetricUnit(MilliSecondsValue);
        /// <summary> ByteSeconds. </summary>
        public static MonitorMetricUnit ByteSeconds { get; } = new MonitorMetricUnit(ByteSecondsValue);
        /// <summary> Unspecified. </summary>
        public static MonitorMetricUnit Unspecified { get; } = new MonitorMetricUnit(UnspecifiedValue);
        /// <summary> Cores. </summary>
        public static MonitorMetricUnit Cores { get; } = new MonitorMetricUnit(CoresValue);
        /// <summary> MilliCores. </summary>
        public static MonitorMetricUnit MilliCores { get; } = new MonitorMetricUnit(MilliCoresValue);
        /// <summary> NanoCores. </summary>
        public static MonitorMetricUnit NanoCores { get; } = new MonitorMetricUnit(NanoCoresValue);
        /// <summary> BitsPerSecond. </summary>
        public static MonitorMetricUnit BitsPerSecond { get; } = new MonitorMetricUnit(BitsPerSecondValue);
        /// <summary> Determines if two <see cref="MonitorMetricUnit"/> values are the same. </summary>
        public static bool operator ==(MonitorMetricUnit left, MonitorMetricUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorMetricUnit"/> values are not the same. </summary>
        public static bool operator !=(MonitorMetricUnit left, MonitorMetricUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorMetricUnit"/>. </summary>
        public static implicit operator MonitorMetricUnit(string value) => new MonitorMetricUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorMetricUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorMetricUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
