// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Reduces the set of data collected. The syntax allowed depends on the operation. See the operation's description for details. </summary>
    public readonly partial struct MonitorMetricResultType : IEquatable<MonitorMetricResultType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorMetricResultType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorMetricResultType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DataValue = "Data";
        private const string MetadataValue = "Metadata";

        /// <summary> Data. </summary>
        public static MonitorMetricResultType Data { get; } = new MonitorMetricResultType(DataValue);
        /// <summary> Metadata. </summary>
        public static MonitorMetricResultType Metadata { get; } = new MonitorMetricResultType(MetadataValue);
        /// <summary> Determines if two <see cref="MonitorMetricResultType"/> values are the same. </summary>
        public static bool operator ==(MonitorMetricResultType left, MonitorMetricResultType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorMetricResultType"/> values are not the same. </summary>
        public static bool operator !=(MonitorMetricResultType left, MonitorMetricResultType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorMetricResultType"/>. </summary>
        public static implicit operator MonitorMetricResultType(string value) => new MonitorMetricResultType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorMetricResultType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorMetricResultType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
