// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> An alert incident indicates the activation status of an alert rule. </summary>
    public partial class MonitorIncident
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorIncident"/>. </summary>
        internal MonitorIncident()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MonitorIncident"/>. </summary>
        /// <param name="name"> Incident name. </param>
        /// <param name="ruleName"> Rule name that is associated with the incident. </param>
        /// <param name="isActive"> A boolean to indicate whether the incident is active or resolved. </param>
        /// <param name="activatedOn"> The time at which the incident was activated in ISO8601 format. </param>
        /// <param name="resolvedOn"> The time at which the incident was resolved in ISO8601 format. If null, it means the incident is still active. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorIncident(string name, string ruleName, bool? isActive, DateTimeOffset? activatedOn, DateTimeOffset? resolvedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            RuleName = ruleName;
            IsActive = isActive;
            ActivatedOn = activatedOn;
            ResolvedOn = resolvedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Incident name. </summary>
        public string Name { get; }
        /// <summary> Rule name that is associated with the incident. </summary>
        public string RuleName { get; }
        /// <summary> A boolean to indicate whether the incident is active or resolved. </summary>
        public bool? IsActive { get; }
        /// <summary> The time at which the incident was activated in ISO8601 format. </summary>
        public DateTimeOffset? ActivatedOn { get; }
        /// <summary> The time at which the incident was resolved in ISO8601 format. If null, it means the incident is still active. </summary>
        public DateTimeOffset? ResolvedOn { get; }
    }
}
