// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> An Event hub receiver. </summary>
    public partial class MonitorEventHubReceiver
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorEventHubReceiver"/>. </summary>
        /// <param name="name"> The name of the Event hub receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="eventHubNameSpace"> The Event Hub namespace. </param>
        /// <param name="eventHubName"> The name of the specific Event Hub queue. </param>
        /// <param name="subscriptionId"> The Id for the subscription containing this event hub. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/>, <paramref name="eventHubNameSpace"/>, <paramref name="eventHubName"/> or <paramref name="subscriptionId"/> is null. </exception>
        public MonitorEventHubReceiver(string name, string eventHubNameSpace, string eventHubName, string subscriptionId)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(eventHubNameSpace, nameof(eventHubNameSpace));
            Argument.AssertNotNull(eventHubName, nameof(eventHubName));
            Argument.AssertNotNull(subscriptionId, nameof(subscriptionId));

            Name = name;
            EventHubNameSpace = eventHubNameSpace;
            EventHubName = eventHubName;
            SubscriptionId = subscriptionId;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorEventHubReceiver"/>. </summary>
        /// <param name="name"> The name of the Event hub receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="eventHubNameSpace"> The Event Hub namespace. </param>
        /// <param name="eventHubName"> The name of the specific Event Hub queue. </param>
        /// <param name="useCommonAlertSchema"> Indicates whether to use common alert schema. </param>
        /// <param name="tenantId"> The tenant Id for the subscription containing this event hub. </param>
        /// <param name="subscriptionId"> The Id for the subscription containing this event hub. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorEventHubReceiver(string name, string eventHubNameSpace, string eventHubName, bool? useCommonAlertSchema, Guid? tenantId, string subscriptionId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            EventHubNameSpace = eventHubNameSpace;
            EventHubName = eventHubName;
            UseCommonAlertSchema = useCommonAlertSchema;
            TenantId = tenantId;
            SubscriptionId = subscriptionId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorEventHubReceiver"/> for deserialization. </summary>
        internal MonitorEventHubReceiver()
        {
        }

        /// <summary> The name of the Event hub receiver. Names must be unique across all receivers within an action group. </summary>
        public string Name { get; set; }
        /// <summary> The Event Hub namespace. </summary>
        public string EventHubNameSpace { get; set; }
        /// <summary> The name of the specific Event Hub queue. </summary>
        public string EventHubName { get; set; }
        /// <summary> Indicates whether to use common alert schema. </summary>
        public bool? UseCommonAlertSchema { get; set; }
        /// <summary> The tenant Id for the subscription containing this event hub. </summary>
        public Guid? TenantId { get; set; }
        /// <summary> The Id for the subscription containing this event hub. </summary>
        public string SubscriptionId { get; set; }
    }
}
